<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Education_Hub
 */

?><?php
	/**
	 * Hook - education_hub_action_doctype.
	 *
	 * @hooked education_hub_doctype -  10
	 */
	do_action( 'education_hub_action_doctype' );
?>
<head>
	<?php
	/**
	 * Hook - education_hub_action_head.
	 *
	 * @hooked education_hub_head -  10
	 */
	do_action( 'education_hub_action_head' );
	?>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const chatButton = document.getElementById('chatBubbleBtn');
        const chatIframe = document.getElementById('chatIframe');
        const iconImage = document.getElementById('icon-image-chat');
        const isClosedIcon = "https://ims.intedgroup.com/assets/chat-bot/message-icon.svg"
        const isOpenIcon = "https://ims.intedgroup.com/assets/chat-bot/close-circle.svg"
        let isOpen = false;

        // Toggle the chat iframe size
        chatButton.addEventListener('click', function () {
            if (isOpen) {
                iconImage.src = isClosedIcon
                chatIframe.style.width = '50px';
                chatIframe.style.height = '50px';
                chatIframe.style.display = 'none';
            } else {
                iconImage.src = isOpenIcon
                chatIframe.style.width = '320px';
                chatIframe.style.height = '500px';
                chatIframe.style.display = 'block';
            }
            isOpen = !isOpen;
        });

        // Optional: Close iframe when clicking inside it (if you have a button in the iframe)
        window.addEventListener('message', function (event) {
            if (event.data === 'closeChat') {
                chatIframe.style.width = '50px';
                chatIframe.style.height = '50px';
                chatIframe.style.display = 'none';
                isOpen = false;
            }
        });
    });
</script>

<div style="position: fixed;bottom:0;right: 50px;z-index: 99999999;width: 100%;">
    <div style="position: relative">
        <button id="chatBubbleBtn"
            style="background-color: #F49A3A;position: absolute;bottom: 30px;right: 30px;width: 50px;height: 50px;border: none;border-radius: 50%;z-index: 1000000;padding: 12px;">
            <img id='icon-image-chat' alt="chat-icon"
                src="https://dev-ims.intedgroup.com/assets/chat-bot/message-icon.svg" style="height: 25px;" />
        </button>
        <iframe id="chatIframe"
            style="position: absolute; bottom: 85px; right: 30px; height: 50px; width: 50px; z-index: 99999999; display: none;"
            src="https://ims.intedgroup.com/#/chat-bot/intuns" frameBorder="0"></iframe>
    </div>
</div>
	<?php do_action( 'wp_body_open' ); ?>

	<?php
	/**
	 * Hook - education_hub_action_before.
	 *
	 * @hooked education_hub_page_start - 10
	 * @hooked education_hub_skip_to_content - 15
	 */
	do_action( 'education_hub_action_before' );
	?>

    <?php
	  /**
	   * Hook - education_hub_action_before_header.
	   *
	   * @hooked education_hub_header_top_content - 5
	   * @hooked education_hub_header_start - 10
	   */
	  do_action( 'education_hub_action_before_header' );
	?>
		<?php
		/**
		 * Hook - education_hub_action_header.
		 *
		 * @hooked education_hub_site_branding - 10
		 */
		do_action( 'education_hub_action_header' );
		?>
    <?php
	  /**
	   * Hook - education_hub_action_after_header.
	   *
	   * @hooked education_hub_header_end - 10
	   * @hooked education_hub_add_primary_navigation - 20
	   */
	  do_action( 'education_hub_action_after_header' );
	?>

	<?php
	/**
	 * Hook - education_hub_action_before_content.
	 *
	 * @hooked education_hub_add_breadcrumb - 7
	 * @hooked education_hub_content_start - 10
	 */
	do_action( 'education_hub_action_before_content' );
	?>
    <?php
	  /**
	   * Hook - education_hub_action_content.
	   */
	  do_action( 'education_hub_action_content' );
	?>
